# 画面設計書 2-Juliaプロンプト（julia>）

## 概要

メインのJulia式入力・評価・結果表示を行うREPLモードの設計書。構文ハイライト、自動補完、括弧対応ハイライトを備えるJulia対話環境の中核画面である。

### 本画面の処理概要

本画面は、Julia REPLのデフォルトモードであり、ユーザーがJulia式を入力し、評価結果を確認する主要な対話インタフェースである。Read-Eval-Print Loop（REPL）のメインループとして動作する。

**業務上の目的・背景**：Juliaプログラミングにおける対話的な開発を支援する中核的なインタフェースである。ユーザーはJulia式を直接入力して即座に結果を確認でき、プロトタイピング、デバッグ、データ探索などの作業を効率的に行うことができる。3種類のREPL実装（LineEditREPL、BasicREPL、StreamREPL）が存在し、端末の能力に応じて最適な実装が選択される。LineEditREPLは構文ハイライト、自動補完、複数行編集、括弧対応ハイライトなどの高度な編集機能を提供する。

**画面へのアクセス方法**：Juliaプロセス起動後、バナー表示が完了すると自動的にJuliaプロンプトが表示される。他のREPLモード（ヘルプ、シェル、Pkg）からは `Backspace`（行頭）または `Ctrl+C` で戻ることができる。

**主要な操作・処理内容**：
1. ユーザーがJulia式をプロンプトに入力する（構文ハイライト、自動補完、括弧対応ハイライト付き）
2. 入力式が `Meta.parse` / `JuliaSyntax` によりASTに変換される
3. ASTがソフトスコープ変換（`softscope`）を経てREPLバックエンドで `eval` される
4. 評価結果が `show`/`display`/`print` により表示される
5. エラー発生時は `showerror`/`stacktrace` によりエラー情報が表示される
6. 入力履歴がREPLHistoryProviderにより管理・保存される

**画面遷移**：
- 遷移先：`?` キー（行頭） → ヘルプモード、`;` キー（行頭） → シェルモード、`]` キー（行頭） → Pkgモード、`Ctrl+R` → 履歴検索モード、上下矢印キー（入力あり） → プレフィックス検索モード
- 遷移元：ヘルプモード、シェルモード、Pkgモード、履歴検索モード、プレフィックス検索モード
- 終了：`Ctrl+D` でREPL終了

**権限による表示制御**：権限による表示制御は存在しない。アクティブモジュールがMain以外の場合、プロンプトにモジュール名がプレフィックスとして表示される（例: `(MyModule) julia> `）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 102 | REPL | 主機能 | LineEditREPL/BasicREPL/StreamREPLの3実装によるメインのRead-Eval-Print Loop処理 |
| 58 | eval | 主機能 | 入力されたJulia式をevalで評価し結果を返すREPLバックエンドの中核処理 |
| 36 | テキスト出力 | 補助機能 | show/display/printによる評価結果のターミナル表示。IOContextを通じた出力フォーマット制御 |
| 54 | マクロ | 補助機能 | 入力コード内のマクロ展開処理。REPLCompletionsでのマクロ補完サポート |
| 55 | 式オブジェクト（Expr） | 補助機能 | 入力文字列のMeta.parseによるAST構築とREPLバックエンドでの式評価 |
| 64 | エラー表示 | 補助機能 | 評価エラー発生時のshowerror/stacktraceによるエラーメッセージ・スタックトレース表示 |
| 62 | 例外機構 | 補助機能 | try/catchによるREPL評価ループ内のエラーハンドリング。エラー発生時もREPLを継続する |
| 88 | パーサー | 補助機能 | JuliaSyntax.jlベースのパーサーによる入力式の構文解析。括弧対応・入力完了判定に使用 |
| 40 | ロギング | 補助機能 | @debug/@info/@warn/@errorマクロによるログ出力がREPL画面に表示される |
| 39 | マルチメディアI/O | 補助機能 | display関数によるリッチ表示（MIME型に応じた出力）のREPLディスプレイへの統合 |
| 59 | モジュールシステム | 補助機能 | プロンプトにアクティブモジュール名を表示。using/importによるモジュール操作をREPLから実行 |
| 129 | Docsシステム | 遷移先機能 | 「?」キー押下によるヘルプモードへの遷移 |
| 123 | Pkg | 遷移先機能 | 「]」キー押下によるPkgモードへの遷移 |
| 70 | コマンド実行 | 遷移先機能 | 「;」キー押下によるシェルモードへの遷移 |
| 114 | InteractiveUtils | 補助機能 | @code_warntype等の対話的開発ユーティリティをREPLから呼び出し |

## 画面種別

対話型入力・評価・結果表示（REPL）

## URL/ルーティング

該当なし（ターミナルベースのCLIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| Julia式（テキスト入力） | 入力 | String | ユーザーがプロンプトに入力するJulia式 |
| 評価結果 | 出力 | Any | eval()による式評価の結果値。show()で表示 |
| エラー情報 | 出力 | Exception | 評価エラー時のスタックトレース付きエラーメッセージ |
| プロンプト文字列 | 出力 | String | `julia> ` またはモジュールプレフィックス付き |

## 表示項目

| 項目名 | 表示内容 | 条件 |
|--------|----------|------|
| プロンプト | `julia> ` | Mainモジュール時 |
| モジュールプレフィックス付きプロンプト | `(ModuleName) julia> ` | アクティブモジュールがMain以外の場合 |
| 入力テキスト | 構文ハイライト付きのJulia式 | LineEditREPL使用時 |
| 評価結果 | show()/display()による表示 | 式がセミコロンで終了しない場合 |
| エラーメッセージ | showerror()による赤色エラー表示 | 評価エラー発生時 |

## イベント仕様

### 1-式入力・評価（Enter）

ユーザーがJulia式を入力し、Enterキーを押下する。式が完全（括弧が閉じている等）であれば、`on_enter` コールバックにより入力が確定され、REPLバックエンドに送信される。バックエンドでは `repl_backend_loop` がChannelを通じてASTを受け取り、`eval` を実行して結果をレスポンスチャネルに返す。フロントエンドは結果を `print_response` で表示する。

### 2-モード遷移（行頭でのキー入力）

行頭で特殊キー（`?`, `;`, `]`）を入力すると、対応するREPLモードに遷移する。`mode_keymap` で定義されたキーマップにより、`transition()` 関数で対象モードのPromptに切り替わる。

### 3-自動補完（Tab）

Tabキー押下で `REPLCompletionProvider` による補完候補が表示される。関数名、変数名、パス、モジュール名等の補完に対応する。

### 4-履歴ナビゲーション（上下矢印）

上下矢印キーで入力履歴を前後に移動する。入力がある状態では `PrefixHistoryPrompt` によるプレフィックス検索モードに入る。

### 5-REPL終了（Ctrl+D）

空の行で `Ctrl+D` を押下するとREPLが終了する。

## データベース更新仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない。履歴は `~/.julia/logs/repl_history.jl` ファイルに保存される）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | エラー | 各種例外メッセージ + スタックトレース | eval実行時にエラーが発生した場合 |
| - | 警告 | 非公開シンボルアクセス警告 | 非公開シンボルへのアクセス時（print_qualified_access_warning） |
| - | 情報 | @info等のログ出力 | ユーザーコード内でのロギングマクロ使用時 |

## 例外処理

| 例外 | 発生条件 | 対応 |
|------|----------|------|
| 評価エラー（任意のException） | ユーザー入力式のeval中にエラー発生 | try/catchでキャッチし、showerror()でエラーを表示してREPLを継続 |
| InterruptException | Ctrl+C押下 | 現在の評価を中断し、新しいプロンプトを表示 |
| EOFError | Ctrl+D押下または入力ストリーム終端 | REPLを正常終了 |
| パースエラー | 不正な構文の入力 | :incomplete の場合は継続行入力を促す。:error の場合はエラーメッセージ表示 |

## 備考

- REPLバックエンドとフロントエンドは `Channel` を通じて非同期通信する（`repl_channel` と `response_channel`）
- `softscope()` によりREPL固有のスコープ規則が適用される（グローバルスコープでのforループ等で変数がローカルにならない）
- `ast_transforms` により式の評価前に変換を適用できる（パッケージの自動インストールフック等）
- セミコロンで終わる式は評価結果を表示しない（`ends_with_semicolon`）
- 3種類のREPL実装：LineEditREPL（完全機能）、BasicREPL（基本機能）、StreamREPL（ストリームベース）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

REPLの中核データ構造はREPLBackendとPromptである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | REPLBackend構造体（118-132行）: repl_channel, response_channel, ast_transforms フィールドを確認 |
| 1-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | LineEditREPL構造体（764-776行）: 端末、色設定、履歴ファイルフラグ等のフィールドを確認 |
| 1-3 | LineEdit.jl | `stdlib/REPL/src/LineEdit.jl` | Prompt構造体: プロンプト文字列、補完プロバイダー、on_enter/on_doneコールバックを確認 |

**読解のコツ**: REPLはフロントエンド（UI）とバックエンド（評価）に分離されており、Channel型を介して非同期に通信する。この分離を意識して読むことが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | run_repl()関数（677-701行）: フロントエンドとバックエンドの起動を確認 |
| 2-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | setup_interface()関数（1254行〜）: 各モード（julia, help, shell, pkg）のPrompt設定を確認 |

**主要処理フロー**:
1. **677行**: run_repl()がREPLBackendRefを作成
2. **688行**: run_frontend()を非同期タスクで起動
3. **692行**: start_repl_backend()でバックエンドループを開始
4. **1290-1301行**: julia_promptの設定（補完、構文ハイライト、括弧対応ハイライト）

#### Step 3: バックエンドの評価ループを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | repl_backend_loop()（448行〜）: Channelからの式受信とeval実行のループ |
| 3-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | softscope()（157-173行）: REPL固有のスコープ変換 |

#### Step 4: フロントエンドの入出力を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | run_frontend(repl::LineEditREPL)の処理フロー |
| 4-2 | REPLCompletions.jl | `stdlib/REPL/src/REPLCompletions.jl` | 補完ロジックの実装 |
| 4-3 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 構文ハイライトと括弧対応ハイライトの実装 |

### プログラム呼び出し階層図

```
run_repl(repl)                           [677行]
    |
    +-- run_frontend(repl, backend_ref)   [非同期タスク]
    |       |
    |       +-- setup_interface(repl)     [1254行]
    |       |       +-- julia_prompt 設定 [1290行]
    |       |       +-- help_mode 設定    [1304行]
    |       |       +-- shell_mode 設定   [1316行]
    |       |       +-- pkg_mode 設定     [1334行]
    |       |
    |       +-- LineEdit.run_interface()
    |               +-- on_enter (入力完了判定)
    |               +-- on_done (入力処理)
    |                       +-- parse_repl_input_line()
    |                       +-- eval_on_backend()
    |                       +-- print_response()
    |
    +-- start_repl_backend(backend)       [441行]
            |
            +-- repl_backend_loop()       [448行]
                    +-- softscope(ast)
                    +-- eval(ast)
                    +-- put!(response_channel, result)
```

### データフロー図

```
[入力]                  [処理]                         [出力]

ユーザー入力     -----> LineEdit (テキスト編集)   -----> 構文ハイライト表示
   |                        |
   |                  parse_repl_input_line()
   |                        |
   +-- repl_channel ------> softscope()
                            eval()                -----> response_channel
                                                         |
                                                   print_response()
                                                         |
                                                   show()/display()  ----> ターミナル出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | REPLモジュールメイン。バックエンド、フロントエンド、各モード設定 |
| LineEdit.jl | `stdlib/REPL/src/LineEdit.jl` | ソース | 行編集エンジン。Prompt構造体、キーマップ、モード遷移 |
| REPLCompletions.jl | `stdlib/REPL/src/REPLCompletions.jl` | ソース | Tab補完ロジック |
| StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | ソース | 構文ハイライト・括弧対応ハイライト |
| SyntaxUtil.jl | `stdlib/REPL/src/SyntaxUtil.jl` | ソース | 構文解析ユーティリティ |
| options.jl | `stdlib/REPL/src/options.jl` | ソース | REPLオプション設定 |
| client.jl | `base/client.jl` | ソース | repl_cmd()、REPL起動処理 |
